#include "pch.h"
#include "Lan.h"
#include <locale.h>
#include <mmsystem.h>

// RXgN^
CLan::CLan()
	: m_Socket()
	, m_TransferBuffer()
	, m_ReceiveData(_T(""))
{
}

// fXgN^
CLan::~CLan()
{
}

// (1)ڑ
BOOL CLan::OpenInterface(CString HostAddress, UINT HostPort)
{
#ifdef _UNICODE
	size_t Length;
#endif
	char IpAddress[64];
	CString ErrorMessage;
	int Result;

#ifdef _UNICODE
	wcstombs_s(&Length, IpAddress, sizeof(IpAddress), HostAddress, _TRUNCATE);			// Ch}`oCgɕϊ
#else
	_tcscpy_s(IpAddress, sizeof(IpAddress), HostAddress);
#endif
	Result = m_Socket.Connect(IpAddress, HostPort);										// \Pbg̃I[v
	if (Result != 0) {
		ErrorMessage = GetLastErrorMessage(Result);
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	return TRUE;
}

// (2)ؒf
void CLan::CloseInterface()
{
	CString ErrorMessage;
	int Result;

	Result = m_Socket.Disconnect();														// \Pbg̃N[Y
	if (Result != 0) {
		ErrorMessage = GetLastErrorMessage(Result);
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
	}
}

// (3)R}hM
BOOL CLan::SendMsg(CString SendData)
{
#ifdef _UNICODE
	size_t Length;
#endif
	CString ErrorMessage;
	int Result;

	SendData = SendData + _T("\r\n");													// ^[~l[^uCR+LFvt
#ifdef _UNICODE
	wcstombs_s(&Length, m_TransferBuffer, sizeof(m_TransferBuffer), SendData, _TRUNCATE);	// Ch}`oCgɕϊ
#else
	_tcscpy_s(m_TransferBuffer, sizeof(m_TransferBuffer), SendData);
#endif
	Result = m_Socket.Send(m_TransferBuffer);											// \PbgɑM
	if (Result != 0) {
		ErrorMessage = GetLastErrorMessage(Result);
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	return TRUE;
}

// (4)M
BOOL CLan::ReceiveMsg(DWORD Timeout)
{
	DWORD StartTime;
	CString Buffer;
	BOOL Status = FALSE;
	CString ErrorMessage;
	int Result;

	m_ReceiveData = _T("");																// Mf[^NA
	StartTime = timeGetTime();
	// ^[~l[^uLFvM܂Ń[v
	for (;;) {
		Result = m_Socket.Receive(Buffer, 1000);										// \PbgM
		if (Result != 0) {
			m_ReceiveData = _T("Error");
			ErrorMessage = GetLastErrorMessage(Result);
			MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
			Status = FALSE;
			break;
		}
		if (Buffer.GetLength() > 1) {
			Buffer.Replace(_T("\r"), _T(""));											// Mf[^́uCRv폜
			int Index = Buffer.Find(_T("\n"));
			if (Index >= 0) {															// ^[~l[^uLFvMI
				m_ReceiveData = m_ReceiveData + Buffer.Mid(0, Index);					// uLFv̎O܂ł̎Mf[^ۑ
				Status = TRUE;;
				break;
			}
			else {
				m_ReceiveData = m_ReceiveData + Buffer;									// Mf[^ۑ
			}
		}
		// ^CAEg
		if (timeGetTime() > StartTime + Timeout) {
			m_ReceiveData = _T("Timeout");
			Status = FALSE;
			break;
		}
	}

	return Status;
}

// (5)R}hM
BOOL CLan::SendQueryMsg(CString SendData, DWORD Timeout)
{
	BOOL Result;

	Result = SendMsg(SendData);															// R}hM
	if (Result == TRUE) {
		if (SendData.Find(_T("?")) != -1) {
			Result = ReceiveMsg(Timeout);												// M牞M
		}
	}

	return Result;
}

// G[bZ[W擾
CString CLan::GetLastErrorMessage(DWORD MessageId)
{
	PVOID pBuffer = NULL;
	CString ErrorMessage;

	if (FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_MAX_WIDTH_MASK,
		NULL, MessageId, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), reinterpret_cast<PTSTR>(&pBuffer), 0, NULL) == 0 || pBuffer == NULL) {
		return ErrorMessage;
	}
	ErrorMessage = static_cast<PTSTR>(pBuffer);
	LocalFree(pBuffer);

	return ErrorMessage;
}
